//
//  BIPDFWebView.h
//  WebToPDFDesktop
//
//  Created by Patrick Rogers MC on 09-09-24.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>

/** 
 * To write a pdf representation of a web page to a file call
 * 
 * [BIPDFWebView webViewToLoadURL:documentURL width:width delegate:self];
 *
 * and implement:
 *	- (void)webView:(BIPDFWebView *)sender didFinishLoadForFrame:(WebFrame *)frame {
 *		if ([frame isEqual:webView.mainFrame]) {			
 *			[sender.pdfRepresentation writeToFile:@"/some/path/you/like" atomically:NO];
 *		}
 *		// Perform any clean up
 *	}
 *
 *	- (void)webView:(WebView *)sender didFailLoadWithError:(NSError *)error forFrame:(WebFrame *)frame {
 *		[[NSAlert alertWithError:error] runModal];
 *		// Perform any clean up
 *	}
 */

@interface BIPDFWebView : WebView
{
}

- (NSData *)pdfRepresentation;

+ (BIPDFWebView *)webViewToLoadURL:(NSURL *)url width:(float)width printBackgroundImages:(BOOL)printBackground delegate:(id)delegateInit;

- (void)writePDFRepresentationToPasteboard:(NSPasteboard *)pasteboard;

@end
